/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.nasmob.nswitch.sdk.NSWTrackManager;
import com.nasmob.nswitch.sdk.PrefsManager;
import com.nasmob.nswitch.sdk.ThreadCommand;

class GetAndroidAdIdCommand
extends ThreadCommand {
    Context context;
    boolean isGooglePlay;
    public static final int ERR_GAID_EXCEPTION = 2000;
    public static final int ERR_UNAVAILABLE_GOOGLE_PLAY_SERVICE = 2001;
    public static final int ERR_GAID_TIMEOUT = 2002;

    public GetAndroidAdIdCommand(Context context) {
        this.context = context;
        this.isGooglePlay = this.checkGooglePlay(context);
    }

    public boolean checkGooglePlay(Context context) {
        try {
            Class<?> advertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            this.isGooglePlay = advertisingIdClientClass != null;
        }
        catch (ClassNotFoundException e) {
            this.isGooglePlay = false;
        }
        return this.isGooglePlay;
    }

    @Override
    public void handleCommand() {
        try {
            if (this.isGooglePlay) {
                AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context.getApplicationContext());
                String newId = String.valueOf(!adInfo.isLimitAdTrackingEnabled() ? "0" : "1") + "_" + adInfo.getId();
                NSWTrackManager.getInstance().setAdvertisingId(newId);
                Log.d((String)"NSW", (String)("GAID : " + String.valueOf(newId)));
                if (this.context != null) {
                    PrefsManager.writePrefs(this.context, "GLAdvertisingID", newId);
                }
            } else {
                this.errorCode = 2001;
                Log.e((String)"NSW", (String)"GooglePlayServices is not available");
            }
        }
        catch (Throwable e) {
            this.errorCode = 2000;
            Log.e((String)"NSW", (String)"Get GAID Fail");
            e.printStackTrace();
        }
        this.fire();
    }
}

