/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.Context;
import android.util.Log;
import com.nasmob.nswitch.sdk.NSWTracker;
import com.nasmob.nswitch.sdk.PrefsManager;
import com.nasmob.nswitch.sdk.UserDevice;
import com.nasmob.nswitch.sdk.Utils;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NSWTrackManager {
    private static NSWTrackManager sInstance;
    private static final ConcurrentLinkedQueue<String> queue;
    private static final Object queueLock;
    private static final ScheduledExecutorService scheduler;
    private static boolean isUploading;
    private static boolean isLoggable;
    private static boolean isTestMode;
    private boolean isHasAdvertisingId = false;
    private static long lastActionTime;
    private static long sessionExpirationTime;
    private static long sid;
    private static int mAge;
    private static int mGender;
    public static String mAdvertisingId;
    private static String userDeviceURI;

    static {
        queue = new ConcurrentLinkedQueue();
        queueLock = new Object();
        scheduler = Executors.newScheduledThreadPool(1);
        isUploading = false;
        isLoggable = true;
        isTestMode = false;
        sessionExpirationTime = 60L;
        sid = 0L;
        mAge = 0;
        mGender = 0;
        mAdvertisingId = null;
        userDeviceURI = null;
    }

    public static NSWTrackManager getInstance() {
        if (sInstance == null) {
            sInstance = new NSWTrackManager();
        }
        return sInstance;
    }

    public NSWTracker getTracker(Context context, String appId) {
        if (context == null || appId == null) {
            return null;
        }
        NSWTracker tracker = new NSWTracker(context, appId);
        return tracker;
    }

    public void setTestMode(boolean testMode) {
        isTestMode = testMode;
    }

    public boolean isLoggable() {
        return isLoggable;
    }

    private boolean isTestMode() {
        return isTestMode;
    }

    public void setSessionExpirationTime(long sessionExpirationTime) {
        NSWTrackManager.sessionExpirationTime = sessionExpirationTime;
    }

    public void initSession() {
        sid = (long)((double)System.currentTimeMillis() / 1000.0);
    }

    private boolean updateSession() {
        boolean isSessionChanged = false;
        long curTime = (long)((double)System.currentTimeMillis() / 1000.0);
        if (curTime - lastActionTime > sessionExpirationTime || curTime - lastActionTime < 0L) {
            sid = curTime;
            isSessionChanged = true;
        }
        lastActionTime = curTime;
        return isSessionChanged;
    }

    public void setGender(int gender) {
        mGender = gender;
    }

    public void setGenderMale() {
        mGender = 1;
    }

    public void setGenderFemale() {
        mGender = 2;
    }

    private int getGender() {
        return mGender;
    }

    public void setAge(int age) {
        mAge = age;
    }

    private int getAge() {
        return mAge;
    }

    public void setAdvertisingId(String advertisingId) {
        mAdvertisingId = advertisingId;
        this.isHasAdvertisingId = true;
    }

    private String getAdvertisingId() {
        return mAdvertisingId;
    }

    public boolean getHasAdvertisingId() {
        return this.isHasAdvertisingId;
    }

    public static String getSDKVersion() {
        return "1.1.2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(WeakReference<Context> ctxtRef, String appId, String udid, String byName) {
        if (ctxtRef == null || ctxtRef.get() == null || appId == null || udid == null) {
            return;
        }
        boolean isSessionChanged = false;
        Context context = (Context)ctxtRef.get();
        String className = context.getClass().getName();
        String pkg = context.getApplicationContext().getPackageName();
        String referrer = PrefsManager.readPrefs(context, "IR_");
        String advertisingId = this.getAdvertisingId();
        if (udid == null || udid.length() == 0) {
            udid = UserDevice.getDeviceUDID(context, advertisingId);
        }
        isSessionChanged = this.updateSession();
        String data = "/track?";
        data = String.valueOf(data) + "tm=" + Utils.getDateNow("yyyyMMddHHmmss");
        data = String.valueOf(data) + "&appid=" + appId;
        data = String.valueOf(data) + "&udid=" + udid;
        data = String.valueOf(data) + "&sid=" + sid;
        data = String.valueOf(data) + "&flag=1";
        data = String.valueOf(data) + "&view=" + Utils.encodeUrl(byName == null ? className : byName.trim());
        data = String.valueOf(data) + "&pkg=" + Utils.encodeUrl(pkg == null ? "" : pkg);
        data = String.valueOf(data) + "&referrer=" + Utils.encodeUrl(referrer == null ? "" : referrer);
        data = String.valueOf(data) + "&net=" + Utils.encodeUrl(Utils.getNetworkStatus(context));
        data = String.valueOf(data) + "&gen=" + this.getGender();
        data = String.valueOf(data) + "&age=" + this.getAge();
        data = String.valueOf(data) + "&sdk_version=" + Utils.encodeUrl(NSWTrackManager.getSDKVersion());
        if (isSessionChanged || userDeviceURI == null || userDeviceURI.length() <= 0) {
            userDeviceURI = UserDevice.getUserDeviceToUri(context);
        }
        data = String.valueOf(data) + "&" + userDeviceURI;
        if (advertisingId != null && advertisingId.length() > 0) {
            data = String.valueOf(data) + "&android_ad_id=" + Utils.encodeUrl(advertisingId);
        }
        if (this.isTestMode()) {
            data = String.valueOf(data) + "&tsmd=1";
        }
        Object object = queueLock;
        synchronized (object) {
            queue.offer(data);
        }
        if (Utils.isNetworkConnected(context)) {
            this.uploadTrack();
        }
        if (this.isLoggable()) {
            Log.v((String)"NSW", (String)("Start View: " + data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackPurchaseEvent(WeakReference<Context> ctxtRef, String appId, String udid, String product, double price, String currency) {
        if (ctxtRef == null || ctxtRef.get() == null || appId == null || udid == null || product == null || currency == null) {
            return;
        }
        boolean isSessionChanged = false;
        Context context = (Context)ctxtRef.get();
        String pkg = context.getApplicationContext().getPackageName();
        String referrer = PrefsManager.readPrefs(context, "IR_");
        String advertisingId = this.getAdvertisingId();
        if (udid == null || udid.length() == 0) {
            udid = UserDevice.getDeviceUDID(context, advertisingId);
        }
        product = Utils.encodeUrl(product.trim());
        currency = Utils.encodeUrl(currency.trim());
        isSessionChanged = this.updateSession();
        String data = "/purchase?";
        data = String.valueOf(data) + "tm=" + Utils.getDateNow("yyyyMMddHHmmss");
        data = String.valueOf(data) + "&appid=" + appId;
        data = String.valueOf(data) + "&udid=" + udid;
        data = String.valueOf(data) + "&sid=" + sid;
        data = String.valueOf(data) + "&product=" + product;
        data = String.valueOf(data) + "&price=" + price;
        data = String.valueOf(data) + "&currency=" + currency;
        data = String.valueOf(data) + "&pkg=" + Utils.encodeUrl(pkg == null ? "" : pkg);
        data = String.valueOf(data) + "&referrer=" + Utils.encodeUrl(referrer == null ? "" : referrer);
        data = String.valueOf(data) + "&net=" + Utils.encodeUrl(Utils.getNetworkStatus(context));
        data = String.valueOf(data) + "&gen=" + this.getGender();
        data = String.valueOf(data) + "&age=" + this.getAge();
        data = String.valueOf(data) + "&sdk_version=" + Utils.encodeUrl(NSWTrackManager.getSDKVersion());
        if (isSessionChanged || userDeviceURI == null || userDeviceURI.length() <= 0) {
            userDeviceURI = UserDevice.getUserDeviceToUri(context);
        }
        data = String.valueOf(data) + "&" + userDeviceURI;
        if (advertisingId != null && advertisingId.length() > 0) {
            data = String.valueOf(data) + "&android_ad_id=" + Utils.encodeUrl(advertisingId);
        }
        if (this.isTestMode()) {
            data = String.valueOf(data) + "&tsmd=1";
        }
        Object object = queueLock;
        synchronized (object) {
            queue.offer(data);
        }
        if (Utils.isNetworkConnected(context)) {
            this.uploadTrack();
        }
        if (this.isLoggable()) {
            Log.v((String)"NSW", (String)("Purchase Event: " + data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackEvent(WeakReference<Context> ctxtRef, String appId, String udid, String event) {
        if (ctxtRef == null || ctxtRef.get() == null || appId == null || udid == null || event == null) {
            return;
        }
        boolean isSessionChanged = false;
        Context context = (Context)ctxtRef.get();
        String pkg = context.getApplicationContext().getPackageName();
        String referrer = PrefsManager.readPrefs(context, "IR_");
        String advertisingId = this.getAdvertisingId();
        if (udid == null || udid.length() == 0) {
            udid = UserDevice.getDeviceUDID(context, advertisingId);
        }
        event = Utils.encodeUrl(event.trim());
        isSessionChanged = this.updateSession();
        String data = "/event?";
        data = String.valueOf(data) + "tm=" + Utils.getDateNow("yyyyMMddHHmmss");
        data = String.valueOf(data) + "&appid=" + appId;
        data = String.valueOf(data) + "&udid=" + udid;
        data = String.valueOf(data) + "&sid=" + sid;
        data = String.valueOf(data) + "&action=" + event;
        data = String.valueOf(data) + "&pkg=" + Utils.encodeUrl(pkg == null ? "" : pkg);
        data = String.valueOf(data) + "&referrer=" + Utils.encodeUrl(referrer == null ? "" : referrer);
        data = String.valueOf(data) + "&net=" + Utils.encodeUrl(Utils.getNetworkStatus(context));
        data = String.valueOf(data) + "&gen=" + this.getGender();
        data = String.valueOf(data) + "&age=" + this.getAge();
        data = String.valueOf(data) + "&sdk_version=" + Utils.encodeUrl(NSWTrackManager.getSDKVersion());
        if (isSessionChanged || userDeviceURI == null || userDeviceURI.length() <= 0) {
            userDeviceURI = UserDevice.getUserDeviceToUri(context);
        }
        data = String.valueOf(data) + "&" + userDeviceURI;
        if (advertisingId != null && advertisingId.length() > 0) {
            data = String.valueOf(data) + "&android_ad_id=" + Utils.encodeUrl(advertisingId);
        }
        if (this.isTestMode()) {
            data = String.valueOf(data) + "&tsmd=1";
        }
        Object object = queueLock;
        synchronized (object) {
            queue.offer(data);
        }
        if (Utils.isNetworkConnected(context)) {
            this.uploadTrack();
        }
        if (this.isLoggable()) {
            Log.v((String)"NSW", (String)("Event: " + data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackGoal(WeakReference<Context> ctxtRef, String appId, String udid, String goal, int goalVal) {
        if (ctxtRef == null || ctxtRef.get() == null || appId == null || udid == null || goal == null) {
            return;
        }
        boolean isSessionChanged = false;
        Context context = (Context)ctxtRef.get();
        String referrer = PrefsManager.readPrefs(context, "IR_");
        String pkg = context.getApplicationContext().getPackageName();
        String advertisingId = this.getAdvertisingId();
        if (udid == null || udid.length() == 0) {
            udid = UserDevice.getDeviceUDID(context, advertisingId);
        }
        goal = Utils.encodeUrl(goal.trim());
        isSessionChanged = this.updateSession();
        String data = "/event?";
        data = String.valueOf(data) + "tm=" + Utils.getDateNow("yyyyMMddHHmmss");
        data = String.valueOf(data) + "&appid=" + appId;
        data = String.valueOf(data) + "&udid=" + udid;
        data = String.valueOf(data) + "&sid=" + sid;
        data = String.valueOf(data) + "&action=" + goal;
        data = String.valueOf(data) + "&goal=" + goalVal;
        data = String.valueOf(data) + "&pkg=" + Utils.encodeUrl(pkg == null ? "" : pkg);
        data = String.valueOf(data) + "&referrer=" + Utils.encodeUrl(referrer == null ? "" : referrer);
        data = String.valueOf(data) + "&net=" + Utils.encodeUrl(Utils.getNetworkStatus(context));
        data = String.valueOf(data) + "&gen=" + this.getGender();
        data = String.valueOf(data) + "&age=" + this.getAge();
        data = String.valueOf(data) + "&sdk_version=" + Utils.encodeUrl(NSWTrackManager.getSDKVersion());
        if (isSessionChanged || userDeviceURI == null || userDeviceURI.length() <= 0) {
            userDeviceURI = UserDevice.getUserDeviceToUri(context);
        }
        data = String.valueOf(data) + "&" + userDeviceURI;
        if (advertisingId != null && advertisingId.length() > 0) {
            data = String.valueOf(data) + "&android_ad_id=" + Utils.encodeUrl(advertisingId);
        }
        if (this.isTestMode()) {
            data = String.valueOf(data) + "&tsmd=1";
        }
        Object object = queueLock;
        synchronized (object) {
            queue.offer(data);
        }
        if (Utils.isNetworkConnected(context)) {
            this.uploadTrack();
        }
        if (this.isLoggable()) {
            Log.v((String)"NSW", (String)("Goal Event: " + data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackInstall(Context context, String appId, String udid, String pkg, String referrer) {
        if (context == null || appId == null || udid == null || referrer == null) {
            return;
        }
        boolean isSessionChanged = false;
        referrer = Utils.encodeUrl(referrer);
        pkg = Utils.encodeUrl(pkg == null ? "" : pkg);
        String advertisingId = this.getAdvertisingId();
        if (udid == null || udid.length() == 0) {
            udid = UserDevice.getDeviceUDID(context, advertisingId);
        }
        isSessionChanged = this.updateSession();
        String data = "/install?";
        data = String.valueOf(data) + "tm=" + Utils.getDateNow("yyyyMMddHHmmss");
        data = String.valueOf(data) + "&appid=" + appId;
        data = String.valueOf(data) + "&udid=" + udid;
        data = String.valueOf(data) + "&sid=" + sid;
        data = String.valueOf(data) + "&pkg=" + pkg;
        data = String.valueOf(data) + "&referrer=" + referrer;
        data = String.valueOf(data) + "&net=" + Utils.encodeUrl(Utils.getNetworkStatus(context));
        data = String.valueOf(data) + "&gen=" + this.getGender();
        data = String.valueOf(data) + "&age=" + this.getAge();
        data = String.valueOf(data) + "&sdk_version=" + Utils.encodeUrl(NSWTrackManager.getSDKVersion());
        if (isSessionChanged || userDeviceURI == null || userDeviceURI.length() <= 0) {
            userDeviceURI = UserDevice.getUserDeviceToUri(context);
        }
        data = String.valueOf(data) + "&" + userDeviceURI;
        if (advertisingId != null && advertisingId.length() > 0) {
            data = String.valueOf(data) + "&android_ad_id=" + Utils.encodeUrl(advertisingId);
        }
        if (this.isTestMode()) {
            data = String.valueOf(data) + "&tsmd=1";
        }
        Object object = queueLock;
        synchronized (object) {
            queue.offer(data);
        }
        if (Utils.isNetworkConnected(context)) {
            this.uploadTrack();
        }
        if (this.isLoggable()) {
            Log.v((String)"NSW", (String)("Install: " + data));
        }
    }

    private void uploadTrack() {
        if (isUploading) {
            return;
        }
        scheduler.schedule(new UploadTrackRunnable(), 0L, TimeUnit.SECONDS);
    }

    static /* synthetic */ boolean access$1() {
        return isUploading;
    }

    private static class TryUpload {
        private static final int DEFAULT_RETRIES = 30;
        private int numberOfTriesLeft;

        public TryUpload() {
            this(30);
        }

        public TryUpload(int numberOfRetries) {
            this.numberOfTriesLeft = numberOfRetries;
        }

        public boolean canTryUpload() {
            return this.numberOfTriesLeft > 0;
        }

        public boolean upload(String data) {
            if (data == null) {
                return false;
            }
            while (true) {
                HttpURLConnection conn;
                block9: {
                    int statusCode;
                    block8: {
                        conn = null;
                        --this.numberOfTriesLeft;
                        URL url = new URL("http://track-nswitch.nasmob.com:8018" + data);
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(5000);
                        conn.setUseCaches(false);
                        conn.setRequestMethod("GET");
                        statusCode = conn.getResponseCode();
                        if (statusCode != 200) break block8;
                        return true;
                    }
                    try {
                        Log.v((String)"NSW", (String)("HttpURLConnection Error Code : " + String.valueOf(statusCode)));
                        if (!this.canTryUpload()) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        Log.v((String)"NSW", (String)("Upload Error : " + String.valueOf(e)));
                        if (this.canTryUpload()) break block9;
                        return false;
                    }
                }
                conn.disconnect();
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
    }

    private static class UploadTrackRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String data;
            if (queue.isEmpty()) {
                return;
            }
            isUploading = true;
            while ((data = (String)queue.peek()) != null) {
                TryUpload tryUpload = new TryUpload();
                boolean result = tryUpload.upload(data);
                if (result) {
                    Log.v((String)"NSW", (String)String.format("Track complete : %s ", data));
                } else {
                    Log.v((String)"NSW", (String)String.format("Track fail : %s ", data));
                }
                Object object = queueLock;
                synchronized (object) {
                    queue.poll();
                }
            }
            isUploading = false;
        }
    }
}

