/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.Context;
import android.util.Log;
import com.nasmob.nswitch.sdk.GetAndroidAdIdCommand;
import com.nasmob.nswitch.sdk.NSWTrackManager;
import com.nasmob.nswitch.sdk.PrefsManager;
import com.nasmob.nswitch.sdk.UserDevice;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NSWTracker {
    private WeakReference<Context> ctxtRef = null;
    private String appId = null;
    private String udid = null;
    private boolean isInstalled = false;
    private int[] installCheck = new int[5];
    private int[] advertisingIdCheck = new int[6];
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public NSWTracker(Context context, String appId) {
        String advertisingId;
        String age;
        String gender;
        this.ctxtRef = new WeakReference<Context>(context);
        this.appId = appId;
        this.isInstalled = false;
        int i = 0;
        while (i < 5) {
            this.installCheck[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 6) {
            this.advertisingIdCheck[i] = 0;
            ++i;
        }
        String temp = PrefsManager.readPrefs(context, "IRT_");
        if (temp != null && temp.length() > 0) {
            this.isInstalled = true;
        }
        if ((gender = PrefsManager.readPrefs(context, "Gender")) != null && gender.length() > 0) {
            NSWTrackManager.getInstance().setGender(Integer.parseInt(gender));
        }
        if ((age = PrefsManager.readPrefs(context, "Age")) != null && age.length() > 0) {
            NSWTrackManager.getInstance().setAge(Integer.parseInt(age));
        }
        if ((advertisingId = PrefsManager.readPrefs(context, "GLAdvertisingID")) != null && advertisingId.length() > 0) {
            NSWTrackManager.getInstance().setAdvertisingId(advertisingId);
            this.udid = UserDevice.getDeviceUDID(context, advertisingId);
        } else {
            this.setAdvertisingID(context);
        }
    }

    public NSWTrackManager getTrackManager() {
        return NSWTrackManager.getInstance();
    }

    private boolean isInitialized() {
        if (this.ctxtRef == null || this.appId == null) {
            return false;
        }
        String advertisingId = PrefsManager.readPrefs((Context)this.ctxtRef.get(), "GLAdvertisingID");
        this.udid = this.udid == null && advertisingId != null && advertisingId.length() > 0 ? UserDevice.getDeviceUDID((Context)this.ctxtRef.get(), advertisingId) : "";
        return true;
    }

    public void setAge(int age) {
        NSWTrackManager.getInstance().setAge(age);
        if (this.ctxtRef == null) {
            return;
        }
        Context context = (Context)this.ctxtRef.get();
        if (context != null) {
            PrefsManager.writePrefs(context, "Age", String.valueOf(age));
        }
    }

    public void setGenderMale() {
        NSWTrackManager.getInstance().setGenderMale();
        if (this.ctxtRef == null) {
            return;
        }
        Context context = (Context)this.ctxtRef.get();
        if (context != null) {
            PrefsManager.writePrefs(context, "Gender", "1");
        }
    }

    public void setGenderFemale() {
        NSWTrackManager.getInstance().setGenderFemale();
        if (this.ctxtRef == null) {
            return;
        }
        Context context = (Context)this.ctxtRef.get();
        if (context != null) {
            PrefsManager.writePrefs(context, "Gender", "2");
        }
    }

    private void setAdvertisingID(Context context) {
        if (context == null) {
            return;
        }
        GetAndroidAdIdCommand adIdCommand = new GetAndroidAdIdCommand(context);
        adIdCommand.execute();
    }

    public void setSessionExpirationTime(long sessionExpirationTime) {
        NSWTrackManager.getInstance().setSessionExpirationTime(sessionExpirationTime);
    }

    public void initSession() {
        NSWTrackManager.getInstance().initSession();
    }

    public void track() {
        if (this.isInitialized()) {
            scheduler.schedule(new HandleTrackRunnable(this, null, 0), (long)(this.isInstalled ? (NSWTrackManager.getInstance().getHasAdvertisingId() ? 0 : 1) : 1), TimeUnit.SECONDS);
        } else if (this.isLoggable()) {
            Log.e((String)"NSW", (String)"track start failed.");
        }
    }

    public void track(String byName) {
        if (this.isInitialized()) {
            if (byName == null || byName.length() <= 0) {
                byName = null;
            }
            scheduler.schedule(new HandleTrackRunnable(this, byName, 0), (long)(this.isInstalled ? (NSWTrackManager.getInstance().getHasAdvertisingId() ? 0 : 1) : 1), TimeUnit.SECONDS);
        } else if (this.isLoggable()) {
            Log.e((String)"NSW", (String)"track start failed.");
        }
    }

    public void trackPurchaseEvent(String product, double price, String currency) {
        if (this.isInitialized()) {
            scheduler.schedule(new HandleTrackPurchaseRunnable(this, product, price, currency), (long)(this.isInstalled ? (NSWTrackManager.getInstance().getHasAdvertisingId() ? 0 : 1) : 1), TimeUnit.SECONDS);
        } else if (this.isLoggable()) {
            Log.e((String)"NSW", (String)"track purchase event failed.");
        }
    }

    public void trackEvent(String event) {
        if (this.isInitialized()) {
            scheduler.schedule(new HandleTrackRunnable(this, event, 1), (long)(this.isInstalled ? (NSWTrackManager.getInstance().getHasAdvertisingId() ? 0 : 1) : 1), TimeUnit.SECONDS);
        } else if (this.isLoggable()) {
            Log.e((String)"NSW", (String)"track event failed.");
        }
    }

    public void trackConversion(String conversion) {
        if (this.isInitialized()) {
            scheduler.schedule(new HandleTrackRunnable(this, conversion, 4), (long)(this.isInstalled ? (NSWTrackManager.getInstance().getHasAdvertisingId() ? 0 : 1) : 1), TimeUnit.SECONDS);
        } else if (this.isLoggable()) {
            Log.e((String)"NSW", (String)"track conversion failed.");
        }
    }

    private boolean isLoggable() {
        return NSWTrackManager.getInstance().isLoggable();
    }

    public void setTestMode(boolean testMode) {
        NSWTrackManager.getInstance().setTestMode(testMode);
    }

    private boolean readInstalled(int idx) {
        String temp = PrefsManager.readPrefs((Context)this.ctxtRef.get(), "IRT_");
        if (temp != null && temp.length() > 0) {
            return true;
        }
        if (idx >= 0 && idx < 5) {
            int n = idx;
            this.installCheck[n] = this.installCheck[n] + 1;
        }
        return false;
    }

    private void writeInstalled() {
        long curTime = (long)((double)System.currentTimeMillis() / 1000.0);
        PrefsManager.writePrefs((Context)this.ctxtRef.get(), "IRT_", String.valueOf(curTime));
    }

    private boolean readHasAdvertisingId(int idx) {
        String advertisingId = PrefsManager.readPrefs((Context)this.ctxtRef.get(), "GLAdvertisingID");
        if (advertisingId != null && advertisingId.length() > 0) {
            NSWTrackManager.getInstance().setAdvertisingId(advertisingId);
            return true;
        }
        if (idx >= 0 && idx < 6) {
            int n = idx;
            this.advertisingIdCheck[n] = this.advertisingIdCheck[n] + 1;
        }
        return false;
    }

    private static class HandleTrackPurchaseRunnable
    implements Runnable {
        private WeakReference<NSWTracker> ref = null;
        private String name = null;
        private String currency = null;
        private double price = 0.0;

        public HandleTrackPurchaseRunnable(NSWTracker tracker, String Product, double Price, String Currency) {
            this.ref = new WeakReference<NSWTracker>(tracker);
            this.name = Product;
            this.currency = Currency;
            this.price = Price;
        }

        @Override
        public void run() {
            NSWTracker tracker = (NSWTracker)this.ref.get();
            if (tracker != null) {
                if (!tracker.isInstalled && tracker.installCheck[2] < 30) {
                    tracker.isInstalled = tracker.readInstalled(2);
                    tracker.trackPurchaseEvent(this.name, this.price, this.currency);
                } else if (!NSWTrackManager.getInstance().getHasAdvertisingId() && tracker.advertisingIdCheck[2] < 10) {
                    tracker.readHasAdvertisingId(2);
                    Log.d((String)"NSW", (String)"Google Advertising ID is null");
                    tracker.trackPurchaseEvent(this.name, this.price, this.currency);
                } else {
                    NSWTrackManager.getInstance().trackPurchaseEvent(tracker.ctxtRef, tracker.appId, tracker.udid, this.name, this.price, this.currency);
                    if (!tracker.isInstalled) {
                        tracker.writeInstalled();
                        tracker.isInstalled = true;
                    }
                }
            }
        }
    }

    private static class HandleTrackRunnable
    implements Runnable {
        private WeakReference<NSWTracker> ref = null;
        private String name = null;
        private int idx = -1;

        public HandleTrackRunnable(NSWTracker tracker, String action, int trackIdx) {
            this.ref = new WeakReference<NSWTracker>(tracker);
            this.name = action;
            this.idx = trackIdx;
        }

        @Override
        public void run() {
            NSWTracker tracker = (NSWTracker)this.ref.get();
            if (tracker != null && this.idx >= 0 && this.idx < 5) {
                if (!tracker.isInstalled && tracker.installCheck[this.idx] < 30) {
                    Log.d((String)"NSW", (String)"Referrer is null");
                    tracker.isInstalled = tracker.readInstalled(this.idx);
                    switch (this.idx) {
                        case 0: {
                            tracker.track(this.name);
                            break;
                        }
                        case 1: {
                            tracker.trackEvent(this.name);
                            break;
                        }
                        case 4: {
                            tracker.trackConversion(this.name);
                        }
                    }
                } else if (!NSWTrackManager.getInstance().getHasAdvertisingId() && tracker.advertisingIdCheck[this.idx] < 10) {
                    tracker.readHasAdvertisingId(this.idx);
                    Log.d((String)"NSW", (String)"Google Advertising ID is null");
                    switch (this.idx) {
                        case 0: {
                            tracker.track(this.name);
                            break;
                        }
                        case 1: {
                            tracker.trackEvent(this.name);
                            break;
                        }
                        case 4: {
                            tracker.trackConversion(this.name);
                        }
                    }
                } else {
                    switch (this.idx) {
                        case 0: {
                            NSWTrackManager.getInstance().track(tracker.ctxtRef, tracker.appId, tracker.udid, this.name);
                            break;
                        }
                        case 1: {
                            NSWTrackManager.getInstance().trackEvent(tracker.ctxtRef, tracker.appId, tracker.udid, this.name);
                            break;
                        }
                        case 4: {
                            NSWTrackManager.getInstance().trackGoal(tracker.ctxtRef, tracker.appId, tracker.udid, this.name, 2);
                        }
                    }
                    if (!tracker.isInstalled) {
                        tracker.writeInstalled();
                        tracker.isInstalled = true;
                    }
                }
            }
        }
    }
}

