/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class Utils {
    public static String md5(String src) {
        String result = null;
        if (src != null && src.length() > 0) {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(src.getBytes(), 0, src.length());
                result = String.format("%032x", new BigInteger(1, md5.digest()));
            }
            catch (NoSuchAlgorithmException nsae) {
                result = src.substring(0, 32);
            }
        }
        while (result.length() < 32) {
            result = "0" + result;
        }
        return result;
    }

    public static String sha1(String src) {
        String result = null;
        if (src != null && src.length() > 0) {
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                sha1.update(src.getBytes(), 0, src.length());
                result = String.format("%040x", new BigInteger(1, sha1.digest()));
            }
            catch (NoSuchAlgorithmException nsae) {
                result = src.substring(0, 40);
            }
        }
        while (result.length() < 40) {
            result = "0" + result;
        }
        return result;
    }

    public static String fnv32(String src) {
        int init = -2128831035;
        int prime = 16777619;
        int hash = -2128831035;
        int len = src.length();
        int i = 0;
        while (i < len) {
            hash ^= src.charAt(i);
            hash *= 16777619;
            ++i;
        }
        return String.valueOf((long)hash & 0xFFFFFFFFL);
    }

    public static String fnv64(String src) {
        long init = -3750763034362895579L;
        long prime = 1099511628211L;
        long hash = -3750763034362895579L;
        int len = src.length();
        int i = 0;
        while (i < len) {
            hash ^= (long)src.charAt(i);
            hash *= 1099511628211L;
            ++i;
        }
        BigInteger b = BigInteger.valueOf(hash);
        if (b.signum() < 0) {
            b = b.add(BigInteger.ONE.shiftLeft(64));
        }
        return b.toString();
    }

    public static String encodeUrl(String src) {
        String result = "";
        if (src != null && src.length() > 0) {
            try {
                result = URLEncoder.encode(src, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String decodeUrl(String src) {
        String result = "";
        if (src != null && src.length() > 0) {
            try {
                result = URLDecoder.decode(src, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getDateNow(String pattern) {
        if (pattern != null) {
            Calendar cal = Calendar.getInstance();
            cal.setLenient(true);
            Locale locale = Locale.getDefault();
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
            return sdf.format(cal.getTime());
        }
        return "";
    }

    public static boolean isNetworkConnected(Context context) {
        boolean isConnected = false;
        NetworkInfo mobile = null;
        NetworkInfo wifi = null;
        NetworkInfo wimax = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            switch (ni.getType()) {
                case 0: {
                    mobile = ni;
                }
                case 1: {
                    wifi = ni;
                }
                case 6: {
                    wimax = ni;
                }
            }
        }
        catch (Exception e) {
            isConnected = false;
        }
        isConnected = wifi != null && wifi.isConnected() || mobile != null && mobile.isConnected() || wimax != null && wimax.isConnected();
        return isConnected;
    }

    public static String getNetworkStatus(Context context) {
        NetworkInfo mobile = null;
        NetworkInfo wifi = null;
        NetworkInfo wimax = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            switch (ni.getType()) {
                case 0: {
                    mobile = ni;
                }
                case 1: {
                    wifi = ni;
                }
                case 6: {
                    wimax = ni;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wifi != null && wifi.isConnected()) {
            return "wifi";
        }
        if (wimax != null && wimax.isConnected()) {
            return "wimax";
        }
        if (mobile != null && mobile.isConnected()) {
            if (mobile.getSubtypeName() != null) {
                return mobile.getSubtypeName();
            }
            return "mobile";
        }
        return "unknown";
    }

    public static String whiteToUnderbar(String src) {
        if (src != null && src.length() > 0) {
            src = src.trim().replaceAll("[\\p{Space}\\t\\n\\r]", "_");
        }
        return src;
    }
}

