/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nhn.android.naverlogin.data.OAuthLoginString;
import com.nhn.android.naverlogin.ui.OAuthLoginImage;
import com.nhn.android.naverlogin.util.DeviceDisplayInfo;

public class OAuthLoginLayoutNaverAppDownloadBanner
extends LinearLayout {
    private static final String TAG = "NaverLoginOAuth|OAuthLoginLayoutNaverAppDownloadBanner";
    private Context mContext;
    private float mDensity;
    private int mDensityDpi;

    public OAuthLoginLayoutNaverAppDownloadBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData(context);
        this.initView(attrs);
    }

    public OAuthLoginLayoutNaverAppDownloadBanner(Context context) {
        super(context);
        this.initData(context);
        this.initView(null);
    }

    private void initData(Context context) {
        this.mContext = context;
        this.mDensity = this.mContext.getResources().getDisplayMetrics().density;
        this.mDensityDpi = this.mContext.getResources().getDisplayMetrics().densityDpi;
    }

    private float getTextSizeUpper() {
        if (DeviceDisplayInfo.isXhdpi(this.mDensityDpi)) {
            return 14.0f;
        }
        if (DeviceDisplayInfo.isHdpi(this.mDensityDpi)) {
            return 13.0f;
        }
        return 12.0f;
    }

    private float getTextSizeUnder() {
        if (DeviceDisplayInfo.isXhdpi(this.mDensityDpi)) {
            return 12.0f;
        }
        if (DeviceDisplayInfo.isHdpi(this.mDensityDpi)) {
            return 11.0f;
        }
        return 10.15f;
    }

    private int pxFromDp(double dp) {
        int convPx = (int)(dp * (double)this.mDensity);
        return convPx;
    }

    private void initView(AttributeSet attrs) {
        int width = -1;
        int height = -2;
        if (Build.VERSION.SDK_INT >= 8) {
            width = -1;
        }
        this.setBackgroundColor(Color.rgb((int)254, (int)252, (int)227));
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
        this.addView((View)this.getNaverIconView());
        this.addView((View)this.getLayoutDownloadDesc());
        this.addView((View)this.getCloseBtnLayout());
    }

    private void downloadNaverApp() {
        Uri marketUri = Uri.parse((String)"market://details?id=com.nhn.android.search");
        Intent marketIntent = new Intent("android.intent.action.VIEW", marketUri);
        ((Activity)this.mContext).startActivity(marketIntent);
        ((Activity)this.mContext).finish();
    }

    private ImageView getNaverIconView() {
        ImageView view = new ImageView(this.mContext);
        Drawable drawableBgImage = OAuthLoginImage.getDrawableNaverIcon(this.getResources());
        int paddingDp = 10;
        int paddingPx = this.pxFromDp(paddingDp);
        view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        view.setPadding(paddingPx, paddingPx, 0, paddingPx);
        view.setImageDrawable(drawableBgImage);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuthLoginLayoutNaverAppDownloadBanner.this.downloadNaverApp();
            }
        });
        return view;
    }

    private LinearLayout getLayoutDownloadDesc() {
        LinearLayout layout = new LinearLayout(this.mContext);
        TextView tv1 = new TextView(this.mContext);
        TextView tv2 = new TextView(this.mContext);
        int paddingDp = 10;
        int paddingPx = this.pxFromDp(paddingDp);
        layout.setPadding(paddingPx, paddingPx, 0, paddingPx);
        layout.setOrientation(1);
        layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        layout.setGravity(16);
        layout.setClickable(true);
        int padding4dp = this.pxFromDp(4.0);
        tv1.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        tv1.setPadding(0, padding4dp, 0, padding4dp);
        tv1.setTextColor(Color.rgb((int)51, (int)51, (int)51));
        tv1.setText((CharSequence)OAuthLoginString.naveroauthlogin_string_msg_naverapp_download_desc.getString(this.mContext));
        tv1.setTypeface(null, 1);
        tv1.setTextSize(this.getTextSizeUpper());
        tv2.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        tv2.setPadding(0, 0, 0, padding4dp);
        tv2.setText((CharSequence)OAuthLoginString.naveroauthlogin_string_msg_naverapp_download_link.getString(this.mContext));
        tv2.setTextColor(Color.rgb((int)45, (int)180, (int)0));
        tv2.setPaintFlags(tv2.getPaintFlags() | 8);
        tv2.setTextSize(this.getTextSizeUnder());
        layout.addView((View)tv1);
        layout.addView((View)tv2);
        layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuthLoginLayoutNaverAppDownloadBanner.this.downloadNaverApp();
            }
        });
        return layout;
    }

    private RelativeLayout getCloseBtnLayout() {
        ImageView btnImgClose = new ImageView(this.mContext);
        Drawable drawableBgImage = OAuthLoginImage.getDrawableCloseImg(this.getResources());
        int paddingDp = 10;
        int paddingPx = this.pxFromDp(paddingDp);
        int paramMatchContent = -1;
        if (Build.VERSION.SDK_INT >= 8) {
            paramMatchContent = -1;
        }
        btnImgClose.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, paramMatchContent));
        btnImgClose.setPadding(paddingPx, paddingPx, paddingPx, paddingPx);
        btnImgClose.setImageDrawable(drawableBgImage);
        btnImgClose.setScaleType(ImageView.ScaleType.FIT_START);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)btnImgClose.getLayoutParams();
        params.addRule(11, -1);
        btnImgClose.setLayoutParams((ViewGroup.LayoutParams)params);
        btnImgClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuthLoginLayoutNaverAppDownloadBanner.this.setVisibility(8);
            }
        });
        RelativeLayout layout = new RelativeLayout(this.mContext);
        layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, paramMatchContent, 1.0f));
        layout.addView((View)btnImgClose);
        return layout;
    }
}

