/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;
import com.nhn.android.naverlogin.data.OAuthLoginString;

public class NetworkState {
    static boolean shown = false;

    public static boolean isDataConnected(Context context) {
        boolean connected = true;
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            if (info != null) {
                connected = manager.getActiveNetworkInfo().isConnected();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return connected;
    }

    public static boolean is3GConnected(Context context) {
        NetworkInfo mobile = null;
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            if (manager != null && (mobile = manager.getNetworkInfo(0)) != null && mobile.isConnected()) {
                return true;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo wifi = null;
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            if (manager != null && (wifi = manager.getNetworkInfo(1)).isConnected()) {
                return true;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return false;
    }

    public static void showRetry(final Context context, final RetryListener retryListener) {
        if (shown || context == null) {
            return;
        }
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            return;
        }
        shown = true;
        AlertDialog.Builder dialog = new AlertDialog.Builder(context);
        dialog.setIcon(17301543);
        dialog.setMessage((CharSequence)OAuthLoginString.naveroauthlogin_string_network_state_not_available.getString(context));
        dialog.setPositiveButton((CharSequence)OAuthLoginString.naveroauthlogin_string_msg_retry.getString(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(true);
            }
        });
        dialog.setNegativeButton((CharSequence)OAuthLoginString.naveroauthlogin_string_msg_cancel.getString(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(false);
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface arg0) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(false);
            }
        });
        try {
            dialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean checkConnectivity(Context context, boolean showDialog, RetryListener retryListener) {
        if (NetworkState.isDataConnected(context)) {
            return true;
        }
        if (showDialog) {
            if (retryListener == null) {
                String msg = OAuthLoginString.naveroauthlogin_string_network_state_not_available.getString(context);
                Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
                return false;
            }
            NetworkState.showRetry(context, retryListener);
        }
        return false;
    }

    public static String getNetworkState(Context context) {
        String network = "other";
        if (NetworkState.is3GConnected(context)) {
            network = "cell";
        } else if (NetworkState.isWifiConnected(context)) {
            network = "wifi";
        }
        return network;
    }

    public static interface RetryListener {
        public void onResult(boolean var1);
    }
}

