/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics.volley;

import com.buzzvil.buzzad.analytics.volley.HttpHeaderParser;
import com.buzzvil.buzzad.analytics.volley.NetworkResponse;
import com.buzzvil.buzzad.analytics.volley.Request;
import com.buzzvil.buzzad.analytics.volley.Response;
import java.io.UnsupportedEncodingException;

public class StringRequest
extends Request<String> {
    private Response.Listener<String> mListener;

    public StringRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mListener = listener;
    }

    public StringRequest(String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(0, url, listener, errorListener);
    }

    @Override
    protected void onFinish() {
        super.onFinish();
        this.mListener = null;
    }

    @Override
    protected void deliverResponse(String response) {
        if (this.mListener != null) {
            this.mListener.onResponse(response);
        }
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success(parsed, HttpHeaderParser.parseCacheHeaders(response));
    }
}

