/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics.volley;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import com.buzzvil.buzzad.analytics.volley.BasicNetwork;
import com.buzzvil.buzzad.analytics.volley.DiskBasedCache;
import com.buzzvil.buzzad.analytics.volley.HttpClientStack;
import com.buzzvil.buzzad.analytics.volley.HttpStack;
import com.buzzvil.buzzad.analytics.volley.HurlStack;
import com.buzzvil.buzzad.analytics.volley.RequestQueue;
import java.io.File;
import org.apache.http.client.HttpClient;

public class Volley {
    private static final String DEFAULT_CACHE_DIR = "buzzad";

    public static RequestQueue newRequestQueue(Context context, HttpStack stack, int maxDiskCacheBytes) {
        File cacheDir = new File(context.getCacheDir(), DEFAULT_CACHE_DIR);
        String userAgent = "volley/0";
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            userAgent = packageName + "/" + info.versionCode;
        }
        catch (PackageManager.NameNotFoundException packageName) {
            // empty catch block
        }
        if (stack == null) {
            stack = Build.VERSION.SDK_INT >= 9 ? new HurlStack() : new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)userAgent));
        }
        BasicNetwork network = new BasicNetwork(stack);
        RequestQueue queue = maxDiskCacheBytes <= -1 ? new RequestQueue(new DiskBasedCache(cacheDir), network) : new RequestQueue(new DiskBasedCache(cacheDir, maxDiskCacheBytes), network);
        queue.start();
        return queue;
    }

    public static RequestQueue newRequestQueue(Context context, int maxDiskCacheBytes) {
        return Volley.newRequestQueue(context, null, maxDiskCacheBytes);
    }

    public static RequestQueue newRequestQueue(Context context, HttpStack stack) {
        return Volley.newRequestQueue(context, stack, -1);
    }

    public static RequestQueue newRequestQueue(Context context) {
        return Volley.newRequestQueue(context, null);
    }
}

