/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PreferenceHelper {
    private static SharedPreferences mPrefs;

    PreferenceHelper() {
    }

    public static void init(Context context, String name, boolean useMultiProcess) {
        if (mPrefs == null) {
            if (name == null) {
                throw new NullPointerException("Prefs name may not be null");
            }
            mPrefs = useMultiProcess && Build.VERSION.SDK_INT >= 11 ? context.getSharedPreferences(name, 4) : context.getSharedPreferences(name, 0);
        }
    }

    public static SharedPreferences getPreferences() {
        if (mPrefs != null) {
            return mPrefs;
        }
        throw new RuntimeException("Prefs class not correctly instantiated please call Prefs.init(context, name) first");
    }

    public static Map<String, ?> getAll() {
        return PreferenceHelper.getPreferences().getAll();
    }

    public static int getInt(String key, int defValue) {
        return PreferenceHelper.getPreferences().getInt(key, defValue);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return PreferenceHelper.getPreferences().getBoolean(key, defValue);
    }

    public static long getLong(String key, long defValue) {
        return PreferenceHelper.getPreferences().getLong(key, defValue);
    }

    public static double getDouble(String key, double defValue) {
        return Double.longBitsToDouble(PreferenceHelper.getPreferences().getLong(key, Double.doubleToLongBits(defValue)));
    }

    public static float getFloat(String key, float defValue) {
        return PreferenceHelper.getPreferences().getFloat(key, defValue);
    }

    public static String getString(String key, String defValue) {
        return PreferenceHelper.getPreferences().getString(key, defValue);
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(String key, Set<String> defValue) {
        SharedPreferences prefs = PreferenceHelper.getPreferences();
        if (Build.VERSION.SDK_INT >= 11) {
            return prefs.getStringSet(key, defValue);
        }
        if (prefs.contains(key + "#LENGTH")) {
            HashSet<String> set = new HashSet<String>();
            int stringSetLength = prefs.getInt(key + "#LENGTH", -1);
            if (stringSetLength >= 0) {
                for (int i = 0; i < stringSetLength; ++i) {
                    prefs.getString(key + "[" + i + "]", null);
                }
            }
            return set;
        }
        return defValue;
    }

    public static void putLong(String key, long value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putLong(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putInt(String key, int value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putInt(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putDouble(String key, double value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putLong(key, Double.doubleToRawLongBits(value));
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putFloat(String key, float value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putFloat(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putBoolean(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putString(String key, String value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        editor.putString(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    @TargetApi(value=11)
    public static void putStringSet(String key, Set<String> value) {
        SharedPreferences.Editor editor = PreferenceHelper.getPreferences().edit();
        if (Build.VERSION.SDK_INT >= 11) {
            editor.putStringSet(key, value);
        } else {
            int stringSetLength = 0;
            if (mPrefs.contains(key + "#LENGTH")) {
                stringSetLength = mPrefs.getInt(key + "#LENGTH", -1);
            }
            editor.putInt(key + "#LENGTH", value.size());
            int i = 0;
            for (String aValue : value) {
                editor.putString(key + "[" + i + "]", aValue);
                ++i;
            }
            while (i < stringSetLength) {
                editor.remove(key + "[" + i + "]");
                ++i;
            }
        }
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void remove(String key) {
        int stringSetLength;
        SharedPreferences prefs = PreferenceHelper.getPreferences();
        SharedPreferences.Editor editor = prefs.edit();
        if (prefs.contains(key + "#LENGTH") && (stringSetLength = prefs.getInt(key + "#LENGTH", -1)) >= 0) {
            editor.remove(key + "#LENGTH");
            for (int i = 0; i < stringSetLength; ++i) {
                editor.remove(key + "[" + i + "]");
            }
        }
        editor.remove(key);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static boolean contains(String key) {
        return PreferenceHelper.getPreferences().contains(key);
    }

    public static SharedPreferences.Editor clear() {
        return PreferenceHelper.getPreferences().edit().clear();
    }
}

