/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection.gen;

import com.nhn.android.naverlogin.connection.gen.CommonLoginQuery;
import java.util.HashMap;

public class OAuthQueryGenerator
extends CommonLoginQuery {
    private static final String TAG = "NaverLoginOAuth|OAuthQueryGenerator";
    private static final String OAUTH_REQUEST_AUTH_URL = "https://nid.naver.com/oauth2.0/authorize?";
    private static final String OAUTH_REQUEST_ACCESS_TOKEN_URL = "https://nid.naver.com/oauth2.0/token?";

    public String generateRequestInitUrl(String clientId, String state, String callbackUrl, String locale) {
        return this.generateRequestInitUrl(clientId, state, callbackUrl, locale, null);
    }

    public String generateRequestInitUrl(String clientId, String state, String callbackUrl, String locale, String network) {
        String url = "";
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("response_type", "code");
        paramArray.put("inapp_view", "true");
        paramArray.put("oauth_os", "android");
        paramArray.put("locale", locale);
        if (network != null) {
            paramArray.put("network", network);
        }
        paramArray.put("redirect_uri", callbackUrl);
        paramArray.put("state", state);
        url = String.format("%s%s", OAUTH_REQUEST_AUTH_URL, this.getQueryParameter(paramArray));
        return url;
    }

    public String generateRequestAccessTokenUrl(String clientId, String clientSecret, String state, String code, String locale) {
        String url = "";
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "authorization_code");
        paramArray.put("state", state);
        paramArray.put("code", code);
        paramArray.put("oauth_os", "android");
        paramArray.put("locale", locale);
        url = String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
        return url;
    }

    public String generateRequestRefreshAccessTokenUrl(String clientId, String clientSecret, String refreshToken, String locale) {
        String url = "";
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "refresh_token");
        paramArray.put("refresh_token", refreshToken);
        paramArray.put("oauth_os", "android");
        paramArray.put("locale", locale);
        url = String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
        return url;
    }

    public String generateRequestDeleteAccessTokenUrl(String clientId, String clientSecret, String accessToken, String locale) {
        String url = "";
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "delete");
        paramArray.put("access_token", accessToken);
        paramArray.put("service_provider", "NAVER");
        paramArray.put("oauth_os", "android");
        paramArray.put("locale", locale);
        url = String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
        return url;
    }
}

