/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics;

import android.content.Context;
import android.util.Log;
import com.buzzvil.buzzad.analytics.ApiRequest;
import com.buzzvil.buzzad.analytics.Checker;
import com.buzzvil.buzzad.analytics.GaidManager;
import com.buzzvil.buzzad.analytics.PreferenceHelper;
import com.buzzvil.buzzad.analytics.RequestManager;
import com.buzzvil.buzzad.analytics.volley.Response;
import com.buzzvil.buzzad.analytics.volley.VolleyError;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class BATracker {
    static final String LOG_TAG = "buzzad-analytics";
    static final String OS = "android";
    static String APP_KEY = "";
    static boolean isProcessing_actionCompleted = false;
    static boolean isProcessing_launch = false;

    public static void init(Context context, String appId) {
        RequestManager.init(context);
        PreferenceHelper.init(context, "BUZZVIL_CHECKER", false);
        APP_KEY = appId;
        if (Checker.isNeedRetry()) {
            Log.d((String)LOG_TAG, (String)"retry");
            BATracker.actionCompleted(context);
        }
    }

    public static void launch(final Context context) {
        if (APP_KEY.equals("")) {
            Log.e((String)LOG_TAG, (String)"You must call init(Context, String) before launch(Context)");
            return;
        }
        if (isProcessing_launch) {
            return;
        }
        isProcessing_launch = true;
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String adid = GaidManager.getId(context);
                        if (adid == null) {
                            Log.e((String)BATracker.LOG_TAG, (String)"Google Advertising Identifier is null");
                            return;
                        }
                        int isFirst = Checker.isFirst();
                        final JSONObject event = new JSONObject().put("event_at", BATracker.getCurrentTimestamp()).put("is_first", isFirst).put("action", (Object)"open");
                        JSONArray eventArray = Checker.getEventQueue();
                        eventArray.put((Object)event);
                        JSONObject jsonParams = new JSONObject();
                        jsonParams.put("data", (Object)eventArray);
                        jsonParams.put("ifa", (Object)adid);
                        jsonParams.put("client_at", BATracker.getCurrentTimestamp());
                        jsonParams.put("app_id", (Object)APP_KEY);
                        jsonParams.put("os", (Object)BATracker.OS);
                        jsonParams.put("version", 1010);
                        jsonParams.put("package", (Object)context.getPackageName());
                        if (isFirst == 1) {
                            Checker.setFirstCall();
                        }
                        RequestManager.addToRequestQueue(new ApiRequest("tracking/sdk/batch_event/", jsonParams, new Response.Listener<JSONObject>(){

                            @Override
                            public void onResponse(JSONObject response) {
                                if (response.has("code")) {
                                    Log.d((String)BATracker.LOG_TAG, (String)"api call success");
                                    if (response.optString("code", "0").equals("200")) {
                                        Log.d((String)BATracker.LOG_TAG, (String)"reward is received");
                                    } else {
                                        Log.d((String)BATracker.LOG_TAG, (String)String.format("reward is not yet received(code:%s)", response.optString("code", "0")));
                                    }
                                    Checker.clearEventQueue();
                                } else {
                                    Log.d((String)BATracker.LOG_TAG, (String)"api call fail");
                                    Checker.saveEvent(event);
                                }
                            }
                        }, new Response.ErrorListener(){

                            @Override
                            public void onErrorResponse(VolleyError error) {
                                error.printStackTrace();
                                Log.d((String)BATracker.LOG_TAG, (String)"api call fail");
                                Checker.saveEvent(event);
                            }
                        }));
                        isProcessing_launch = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void actionCompleted(final Context context) {
        if (Checker.isResultReceived()) {
            return;
        }
        if (APP_KEY.equals("")) {
            Log.e((String)LOG_TAG, (String)"You must call init(Context, String) before actionCompleted(Context)");
            return;
        }
        if (isProcessing_actionCompleted) {
            return;
        }
        isProcessing_actionCompleted = true;
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String adid = GaidManager.getId(context);
                        if (adid == null) {
                            Log.e((String)BATracker.LOG_TAG, (String)"Google Advertising Identifier is null");
                            return;
                        }
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("app_id", APP_KEY);
                        params.put("os", BATracker.OS);
                        params.put("version", Integer.toString(1010));
                        params.put("ifa", adid);
                        params.put("package", context.getPackageName());
                        RequestManager.addToRequestQueue(new ApiRequest("action/pb/cpe/", params, new Response.Listener<JSONObject>(){

                            @Override
                            public void onResponse(JSONObject response) {
                                Log.d((String)BATracker.LOG_TAG, (String)"api call success");
                                if (response.has("code")) {
                                    Checker.resultReceived();
                                    Checker.setNeedRetry(false);
                                    if (response.optString("code", "0").equals("200")) {
                                        Log.d((String)BATracker.LOG_TAG, (String)"reward is received");
                                    } else {
                                        Log.d((String)BATracker.LOG_TAG, (String)String.format("reward is not received(code:%s)", response.optString("code", "0")));
                                    }
                                } else {
                                    Checker.setNeedRetry(true);
                                }
                            }
                        }, new Response.ErrorListener(){

                            @Override
                            public void onErrorResponse(VolleyError error) {
                                error.printStackTrace();
                                Log.d((String)BATracker.LOG_TAG, (String)"fail");
                                Checker.setNeedRetry(true);
                            }
                        }));
                        isProcessing_actionCompleted = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getCurrentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }
}

