/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.data;

import android.text.TextUtils;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import java.util.Map;

public class OAuthResponse {
    private String mResultValue;
    private String mAccessToken;
    private long mExpiresIn;
    private String mRefreshToken;
    private String mTokenType;
    private OAuthErrorCode mErrorCode;
    private String mErrorDescription;

    public OAuthResponse(Map<String, String> ret) {
        this.mAccessToken = ret.get("access_token");
        this.mRefreshToken = ret.get("refresh_token");
        this.mTokenType = ret.get("token_type");
        try {
            this.mExpiresIn = Long.parseLong(ret.get("expires_in"));
        }
        catch (Exception e) {
            this.mExpiresIn = 3600L;
        }
        this.mErrorCode = OAuthErrorCode.fromString(ret.get("error"));
        this.mErrorDescription = ret.get("error_description");
        this.mResultValue = ret.get("result");
    }

    public OAuthResponse(OAuthErrorCode errorCode) {
        this.mErrorCode = errorCode;
        this.mErrorDescription = errorCode.getDesc();
    }

    public OAuthResponse(OAuthErrorCode errorCode, String errorDescription) {
        this.mErrorCode = errorCode;
        this.mErrorDescription = errorDescription;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public long getExpiresIn() {
        return this.mExpiresIn;
    }

    public String getTokenType() {
        return this.mTokenType;
    }

    public OAuthErrorCode getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorDesc() {
        return this.mErrorDescription;
    }

    public String getResultValue() {
        return this.mResultValue;
    }

    public boolean isSuccess() {
        if (TextUtils.isEmpty((CharSequence)this.mErrorCode.getCode())) {
            return !TextUtils.isEmpty((CharSequence)this.mAccessToken);
        }
        return false;
    }
}

