/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.NetworkState;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.ui.OAuthLoginImage;
import com.nhn.android.naverlogin.ui.OAuthWebviewUrlUtil;
import com.nhn.android.naverlogin.ui.view.OAuthLoginLayoutNaverAppDownloadBanner;
import com.nhn.android.naverlogin.util.DeviceAppInfo;
import com.nhn.android.naverlogin.util.OAuthLoginUiUtil;

public class OAuthLoginInAppBrowserActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "NaverLoginOAuth|OAuthLoginInAppBrowserActivity";
    private static final String INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE = "IsLoginActivityStarted";
    private static final String INSTANCE_STATE_IS_VISIBLE_BANNER = "isVisibleBanner";
    private Context mContext;
    private byte[] drawableByteBottomBackGroundImg;
    private byte[] drawableByteCloseBtnImg;
    private OAuthLoginLayoutNaverAppDownloadBanner mNaverDownloadBanner;
    private ImageView mImgSeperator;
    private ImageView mImgCloseButton;
    private WebView mWebView;
    private ProgressBar mWebviewProgressbar;
    private LinearLayout mWholeView;
    private LinearLayout mNaviBar;
    public String mInOAuthUrl;
    private String mWebViewContent;
    private OAuthLoginData mOAuthLoginData;
    private boolean mIsLoginActivityStarted = false;
    private String mOAuthSdkVersion;
    private boolean mFixActivityPortrait = true;
    private boolean mVisibleNaverAppDownloadBanner = true;
    final DownloadListener mDefaultDownloadListener = new DownloadListener(){

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Intent viewIntent = new Intent("android.intent.action.VIEW");
            viewIntent.setDataAndType(Uri.parse((String)url), mimetype);
            try {
                OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
            }
            catch (Throwable th) {
                th.printStackTrace();
                try {
                    viewIntent.setData(Uri.parse((String)url));
                    OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initIntentData();
        this.initSavedInstanceStateData(savedInstanceState);
        this.initView(savedInstanceState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)("webview onCreate() fix:" + this.mFixActivityPortrait));
        }
        if (this.mFixActivityPortrait) {
            this.setRequestedOrientation(1);
        }
        this.registerSizeChangeListener();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.initSavedInstanceStateData(savedInstanceState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)("webview onRestoreInstanceState() first:" + this.mIsLoginActivityStarted + ", sdk:" + this.mOAuthSdkVersion + ", fix:" + this.mFixActivityPortrait));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"webview onSaveInstanceState()");
        }
        outState.putBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE, this.mIsLoginActivityStarted);
        if (this.mWebView != null) {
            this.mWebView.saveState(outState);
        }
        outState.putString("SdkVersionCalledFrom", this.mOAuthSdkVersion);
        outState.putBoolean("IsFixActivityPortrait", this.mFixActivityPortrait);
        if (this.mVisibleNaverAppDownloadBanner && this.mNaverDownloadBanner != null && this.mNaverDownloadBanner.getVisibility() == 0) {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, true);
        } else {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, false);
        }
    }

    private void initIntentData() {
        this.mContext = this;
        if (this.getIntent() != null) {
            String clientId = this.getIntent().getStringExtra("ClientId");
            String callbackUrl = this.getIntent().getStringExtra("ClientCallbackUrl");
            String state = this.getIntent().getStringExtra("state");
            String locale = DeviceAppInfo.getBaseInstance().getLocaleString(this.mContext);
            String network = NetworkState.getNetworkState(this.mContext);
            this.mOAuthLoginData = new OAuthLoginData(clientId, null, callbackUrl, state);
            this.mInOAuthUrl = new OAuthQueryGenerator().generateRequestInitUrl(clientId, this.mOAuthLoginData.getInitState(), callbackUrl, locale, network);
            this.mOAuthSdkVersion = this.getIntent().getStringExtra("oauth_sdk_version");
            this.mFixActivityPortrait = OAuthLoginUiUtil.isFixActivityPortrait(this.mOAuthSdkVersion);
        }
    }

    private void initSavedInstanceStateData(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mIsLoginActivityStarted = savedInstanceState.getBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE);
            if (this.mWebView != null) {
                this.mWebView.restoreState(savedInstanceState);
            }
            this.mOAuthSdkVersion = savedInstanceState.getString("SdkVersionCalledFrom");
            this.mFixActivityPortrait = savedInstanceState.getBoolean("IsFixActivityPortrait");
            this.mVisibleNaverAppDownloadBanner = savedInstanceState.getBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER);
        }
    }

    private void runOnlyOnce() {
        if (this.getIntent() != null) {
            String url = this.getIntent().getStringExtra("agreeFormUrl");
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.mInOAuthUrl = url;
            }
            this.mWebViewContent = this.getIntent().getStringExtra("agreeFormContent");
        }
        if (TextUtils.isEmpty((CharSequence)this.mWebViewContent)) {
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)("webview url -> " + this.mInOAuthUrl));
            }
            this.mWebView.loadUrl(this.mInOAuthUrl);
        } else {
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)("webview url -> " + this.mInOAuthUrl));
                Log.d((String)TAG, (String)("webview content -> " + this.mWebViewContent));
            }
            this.mWebView.loadDataWithBaseURL(this.mInOAuthUrl, this.mWebViewContent, "text/html", null, null);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.resumeTimers();
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.onResume();
            }
        }
        if (!this.mIsLoginActivityStarted) {
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)"webview onResume() first");
            }
            this.mIsLoginActivityStarted = true;
            this.runOnlyOnce();
        }
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"webview onResume()");
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mWebView != null && Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onPause();
        }
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"webview onPause()");
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"webview onDestroy()");
        }
        this.drawableByteBottomBackGroundImg = null;
        this.drawableByteCloseBtnImg = null;
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
            if (this.mWholeView != null) {
                this.mWholeView.removeView((View)this.mWebView);
            }
            this.mWebView.removeAllViews();
            this.mWebView.destroy();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initView(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        this.drawableByteBottomBackGroundImg = OAuthLoginImage.hexToByteArray("89504e470d0a1a0a0000000d494844520000000c0000003c0806000000520f5b4a0000000473424954080808087c08648800000093494441544889e596410e80200c0407d34f79f5e4ffbfe2454d00df3024252472eeb2bb6d692940479ccd0403c47e9c97025024c373bfca43b45a1d83ba1e08975408680ee0c221e84e93f6e05b434bf27590267ce1969494cda03d4c9094de4bbd39887f0f364b9a211f105dd661cad490b375a0f924404bcadf4033765cfab8cf9634d2adcb555a3f20ffd7f8e3dab569fd00dbc449301620f2800000000049454e44ae426082");
        this.drawableByteCloseBtnImg = OAuthLoginImage.hexToByteArray("89504e470d0a1a0a0000000d49484452000000260000002008060000007e640ab30000000473424954080808087c08648800000370494441545885ed97cd4beb4c14871fabb64d66504b5b53ad284a515044d18545f01f565444772a7e8b5f4b1515515cccee2e14d3b4a475bc0b5b69ec57d27b37efcbfd4116ed647e7966cee49c13f8a7ff893a5a8c77017d40b8fcdb055e8152c0e704f6e90c6056b9bfbb6cacdb84f2e513f263767c7cac2e2f2f55792c5c1eeb0a0a15c4a7512813d566524a7a7b7b01181d1d4d97ef69158e1aa8263ebf7e4e6eb4636180a3a3232584209148904824e8e9e9e1e5e5c5cf8a3d50151fcbb288c562f57c6ad408cc05585a5a4a472211bababa08854244a3514cd3e4f9f9b9199c07eae0e04099a68965590821d05ad3d1d1c1c8c848f58ed5a851283de64f4f4f4a4a89699a00388e836ddb8c8d8dfd0c2bd5f3f6f7f7959492818101a494944a5f518fc7e32d8f43b374e1817b7c7cac0b97c9647eae3c0cb0b7b7a7a494a452290f543299f4754603e5b1878787ba70e3e3e3e9ea49bbbbbb75a12ccbf2fbe2b404ab81bbbfbf57524a0cc300209fcf63db3613131369809d9d1d25a5c4b22ca4947c7c7c00904aa57c43f905ab81bbbbbb5342080f5c2e97e3eded0d804422e1811a1c1c0c041504ac06eef6f6560921104200502c16715d97502844381ca6582c0230343414182a28580ddcf5f5b58ac562df3b5791ebbab8aecbf0f0705b50d0388ff9d2ebeb2b854201ad75ddeb4f1404ccb35b5b5b5baaf270d77529140a140a055cf72b6b68adb9b9b969a7be026d1efecdcdcdef122384f84e0715452211e02b9de47239e6e6e60287d4cf8e79a03636369461182493490cc3c0755db4d664329974269349e772396cdb466b4d341ac5300caeaeae02ef5c2b300fd4fafa7a5da8ea043b3333937e7f7faf81bbb8b80804e7bb24adadad292104fdfdfd9ef04d4e4ed62d49e7e7e7ca344d4f95701c878585853f2a491ea8d5d555258420994c2284f84e9c5353534d8bf8d9d999324dd393881dc7219bcdb6846b14ca6ff3959515651806f1781cc33028168b68adeb4195cad76bf93fb2d96cdab66d1cc7416b4d2412c1300c4e4f4f7f86b5464d1bc5e5e565659a2695245a2a95f8fcfc647a7abad98a3d708b8b8b69dbb6c9e7f368ade9ececc4344d4e4e4e9a368a2d5bebeded6dd5d7d74777773700b3b3b36db5d6952e36140ad5f3a969ad7d9db1c3c3432584607e7e3e683e6adbc7f75b59a5a075af2d9f66df95ba3cb9bbeabe763e78ff96cf3ffd37f51b1081c17a70bcfc1a0000000049454e44ae426082");
        this.mWebviewProgressbar = new ProgressBar((Context)this, null, 16842872);
        this.mWebviewProgressbar.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 5));
        this.mWebviewProgressbar.setVisibility(8);
        this.mWebviewProgressbar.setMax(100);
        this.mWebView = new WebView((Context)this);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setVerticalScrollbarOverlay(true);
        this.mWebView.setHorizontalScrollbarOverlay(true);
        this.mWebView.setWebViewClient((WebViewClient)new InAppWebViewClient());
        this.mWebView.setWebChromeClient((WebChromeClient)new InAppWebChromeClient());
        this.mWebView.setDownloadListener(this.mDefaultDownloadListener);
        this.mWebView.addJavascriptInterface((Object)new InAppBrowserJavascriptInterface((Context)this), "AndroidLoginWebView");
        String ua = String.valueOf(this.mWebView.getSettings().getUserAgentString()) + " " + DeviceAppInfo.getBaseInstance().getUserAgent((Context)this);
        this.mWebView.getSettings().setUserAgentString(ua);
        this.mNaviBar = new LinearLayout((Context)this);
        LinearLayout.LayoutParams param4navibar = new LinearLayout.LayoutParams(-1, (int)OAuthLoginImage.convertDpToPixel(40.0f, this.mContext));
        this.mNaviBar.setGravity(21);
        this.mNaviBar.setLayoutParams((ViewGroup.LayoutParams)param4navibar);
        this.mNaviBar.setOrientation(0);
        BitmapDrawable bt = new BitmapDrawable(this.getResources(), BitmapFactory.decodeByteArray((byte[])this.drawableByteBottomBackGroundImg, (int)0, (int)this.drawableByteBottomBackGroundImg.length));
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mNaviBar.setBackground((Drawable)bt);
            } else {
                this.mNaviBar.setBackgroundDrawable((Drawable)bt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mImgSeperator = new ImageView((Context)this);
        this.mImgSeperator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)OAuthLoginImage.convertDpToPixel(1.0f, this.mContext), -1));
        this.mImgSeperator.setBackgroundColor(Color.argb((int)255, (int)0, (int)0, (int)0));
        this.mImgSeperator.invalidate();
        this.mImgCloseButton = new ImageView((Context)this);
        this.mImgCloseButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(OAuthLoginImage.getScreenWidth((Activity)this.mContext) / 4, (int)OAuthLoginImage.convertDpToPixel(21.333334f, this.mContext)));
        BitmapDrawable closeIcon = new BitmapDrawable(this.getResources(), BitmapFactory.decodeByteArray((byte[])this.drawableByteCloseBtnImg, (int)0, (int)this.drawableByteCloseBtnImg.length));
        this.mImgCloseButton.setImageDrawable((Drawable)closeIcon);
        this.mImgCloseButton.setClickable(true);
        this.mImgCloseButton.setOnClickListener((View.OnClickListener)this);
        this.mNaviBar.addView((View)this.mImgSeperator);
        this.mNaviBar.addView((View)this.mImgCloseButton);
        if (OAuthLoginDefine.MARKET_LINK_WORKING && this.mVisibleNaverAppDownloadBanner) {
            this.mNaverDownloadBanner = new OAuthLoginLayoutNaverAppDownloadBanner((Context)this);
        }
        this.mWholeView = new LinearLayout((Context)this);
        this.mWholeView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mWholeView.setOrientation(1);
        if (OAuthLoginDefine.MARKET_LINK_WORKING && this.mNaverDownloadBanner != null && this.mVisibleNaverAppDownloadBanner) {
            this.mWholeView.addView((View)this.mNaverDownloadBanner);
        }
        this.mWholeView.addView((View)this.mWebviewProgressbar);
        this.mWholeView.addView((View)this.mWebView);
        this.mWholeView.addView((View)this.mNaviBar);
        this.setContentView((View)this.mWholeView);
    }

    private void registerSizeChangeListener() {
        LinearLayout activityRootView = this.mWholeView;
        activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener((View)activityRootView){
            private final /* synthetic */ View val$activityRootView;
            {
                this.val$activityRootView = view;
            }

            public void onGlobalLayout() {
                Rect r = new Rect();
                this.val$activityRootView.getWindowVisibleDisplayFrame(r);
                int heightDiff = this.val$activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                if (heightDiff > 100) {
                    OAuthLoginInAppBrowserActivity.this.mNaviBar.setVisibility(8);
                } else {
                    OAuthLoginInAppBrowserActivity.this.mNaviBar.setVisibility(0);
                }
            }
        });
    }

    public void onClick(View view) {
        if (view == this.mImgCloseButton) {
            this.finish();
        }
    }

    private boolean loadBrowser(String url) {
        if (url.length() <= 0 || url.contentEquals("about:blank")) {
            return false;
        }
        if (url.startsWith("https://nid.naver.com")) {
            return url.startsWith("https://nid.naver.com/mobile/user/help/idInquiry.nhn") || url.startsWith("https://nid.naver.com/mobile/user/help/pwInquiry.nhn") || url.startsWith("https://nid.naver.com/user/mobile_join.nhn");
        }
        if (url.startsWith("https://nid.naver.com/nidlogin.logout") || url.startsWith("http://nid.naver.com/nidlogin.logout")) {
            return false;
        }
        if (url.contains("/sso/logout.nhn") || url.contains("/sso/cross-domain.nhn") || url.contains("/sso/finalize.nhn")) {
            return false;
        }
        if (url.startsWith("http://cc.naver.com") || url.startsWith("http://cr.naver.com")) {
            return false;
        }
        if (url.startsWith("https://cert.vno.co.kr")) {
            return false;
        }
        if (url.startsWith("https://ipin.ok-name.co.kr")) {
            return false;
        }
        return !url.startsWith("https://ipin.siren24.com");
    }

    public class InAppBrowserJavascriptInterface {
        Context context;

        InAppBrowserJavascriptInterface(Context c) {
            this.context = c;
        }

        @JavascriptInterface
        public void closeWebView() {
            ((Activity)this.context).finish();
        }
    }

    private class InAppWebChromeClient
    extends WebChromeClient {
        private InAppWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setProgress(newProgress);
            }
        }
    }

    private class InAppWebViewClient
    extends WebViewClient {
        private String preUrl = "";

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)OAuthLoginInAppBrowserActivity.TAG, (String)("[star] pre url : " + this.preUrl));
                Log.d((String)OAuthLoginInAppBrowserActivity.TAG, (String)("[star]     url : " + url));
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(false, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.mContext, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.mOAuthLoginData)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                return;
            }
            super.onPageStarted(view, url, favicon);
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(0);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)OAuthLoginInAppBrowserActivity.TAG, (String)("[over] pre url : " + this.preUrl));
                Log.d((String)OAuthLoginInAppBrowserActivity.TAG, (String)("[over]     url : " + url));
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(true, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return true;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.mContext, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.mOAuthLoginData)) {
                return true;
            }
            if (OAuthLoginInAppBrowserActivity.this.loadBrowser(url)) {
                Intent i = new Intent("android.intent.action.VIEW");
                Uri u = Uri.parse((String)url);
                i.setData(u);
                OAuthLoginInAppBrowserActivity.this.startActivity(i);
                return true;
            }
            view.loadUrl(url);
            this.preUrl = url;
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(8);
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(8);
            }
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            super.onFormResubmission(view, dontResend, resend);
        }
    }

    public class OAuthLoginInAppBrowserInIntentData {
        public static final String INTENT_PARAM_KEY_CLIENT_ID = "ClientId";
        public static final String INTENT_PARAM_KEY_CALLBACK_URL = "ClientCallbackUrl";
        public static final String INTENT_PARAM_KEY_STATE = "state";
        public static final String INTENT_PARAM_KEY_APP_NAME = "app_name";
        public static final String INTENT_PARAM_KEY_OAUTH_SDK_VERSION = "oauth_sdk_version";
        public static final String INTENT_PARAM_KEY_AGREE_FORM_URL = "agreeFormUrl";
        public static final String INTENT_PARAM_KEY_AGREE_FORM_CONTENT = "agreeFormContent";
    }

    public class OAuthLoginInAppBrowserOutIntentData {
        public static final String RESULT_CALLBACK = "RESULT_CALLBACK";
    }
}

