/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.nasmob.nswitch.sdk.GetAndroidAdIdCommand;
import com.nasmob.nswitch.sdk.NSWTrackManager;
import com.nasmob.nswitch.sdk.PrefsManager;
import com.nasmob.nswitch.sdk.ThreadCommand;
import com.nasmob.nswitch.sdk.UserDevice;
import com.nasmob.nswitch.sdk.Utils;

public final class InstallReceiver
extends BroadcastReceiver
implements ThreadCommand.OnCommandCompletedListener {
    Context ctxt = null;
    Intent itnt = null;
    NSWTrackManager manager = null;
    String udid = null;
    String pkg = null;
    String referrer = null;
    String appId = null;
    String receiverClassPath = null;
    String receiverName = null;
    int pos = -1;
    static int tryCommandCount = 5;

    public void onReceive(Context context, Intent intent) {
        if ("com.android.vending.INSTALL_REFERRER".equals(intent.getAction())) {
            String advertisingId;
            this.ctxt = context;
            this.itnt = intent;
            this.manager = NSWTrackManager.getInstance();
            this.pkg = context.getPackageName();
            if (intent.hasExtra("referrer")) {
                this.referrer = intent.getStringExtra("referrer");
            }
            if (this.referrer == null) {
                this.referrer = "";
            }
            this.referrer = Utils.decodeUrl(this.referrer).trim();
            Log.v((String)"NSW", (String)("Install Referrer Received: " + this.referrer));
            PrefsManager.writePrefs(context, "IR_", this.referrer);
            PrefsManager.writePrefs(context, "IRT_", String.valueOf((long)((double)System.currentTimeMillis() / 1000.0)));
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo info = pm.getPackageInfo(this.pkg, 130);
                int i = 0;
                while (i < info.receivers.length) {
                    this.receiverName = info.receivers[i].name;
                    if (this.receiverName != null && this.receiverName.indexOf("com.nasmob.nswitch.sdk") != -1) {
                        if (this.appId == null) {
                            this.appId = info.receivers[i].metaData.get("com.nasmob.nswitch.sdk.AppId").toString();
                            if (this.appId != null && this.appId.length() > 0 && (this.pos = this.appId.indexOf(":")) != -1) {
                                this.appId = this.appId.substring(this.pos + 1);
                                this.appId = this.appId.trim();
                            }
                        }
                        if (this.receiverClassPath == null) {
                            this.receiverClassPath = info.receivers[i].metaData.get("com.nasmob.nswitch.sdk.ForwardInstallReceiver").toString();
                        }
                    }
                    if (this.appId == null || this.receiverClassPath == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)"NSW", (String)("(1)Failed to load meta-data, NameNotFound: " + e.getMessage()));
            }
            catch (NullPointerException e) {
                Log.e((String)"NSW", (String)("(1)Failed to load meta-data, NullPointer: " + e.getMessage()));
            }
            catch (Exception e) {
                Log.e((String)"NSW", (String)("(1)Failed to load meta-data : " + e.getMessage()));
            }
            if (this.appId == null || this.receiverClassPath == null) {
                try {
                    ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    Bundle bundle = ai.metaData;
                    if (this.appId == null) {
                        this.appId = bundle.getString("com.nasmob.nswitch.sdk.AppId");
                        if (this.appId != null && this.appId.length() > 0 && (this.pos = this.appId.indexOf(":")) != -1) {
                            this.appId = this.appId.substring(this.pos + 1);
                            this.appId = this.appId.trim();
                        }
                    }
                    if (this.receiverClassPath == null) {
                        this.receiverClassPath = bundle.getString("com.nasmob.nswitch.sdk.ForwardInstallReceiver");
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e((String)"NSW", (String)("(2)Failed to load meta-data, NameNotFound: " + e.getMessage()));
                }
                catch (NullPointerException e) {
                    Log.e((String)"NSW", (String)("(2)Failed to load meta-data, NullPointer: " + e.getMessage()));
                }
                catch (Exception e) {
                    Log.e((String)"NSW", (String)("(2)Failed to load meta-data : " + e.getMessage()));
                }
            }
            if (this.receiverClassPath != null && this.receiverClassPath.length() > 0) {
                try {
                    Class<?> receiverClass = Class.forName(this.receiverClassPath);
                    BroadcastReceiver receiver = (BroadcastReceiver)receiverClass.newInstance();
                    receiver.onReceive(context, intent);
                }
                catch (ClassNotFoundException e) {
                    Log.e((String)"NSW", (String)("Fail to broadcasting, ClassNotFound: " + e.getMessage()));
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"NSW", (String)("Fail to broadcasting, IllegalAccess: " + e.getMessage()));
                }
                catch (InstantiationException e) {
                    Log.e((String)"NSW", (String)("Fail to broadcasting, Instantiation: " + e.getMessage()));
                }
                catch (Exception e) {
                    Log.e((String)"NSW", (String)("Fail to broadcasting : " + e.getMessage()));
                }
            }
            if ((advertisingId = PrefsManager.readPrefs(context, "PREFS_ADVERTISING_ID")) == null || advertisingId.length() == 0) {
                if (this.ctxt != null) {
                    this.setAdvertisingIdCommand();
                }
            } else {
                this.udid = UserDevice.getDeviceUDID(this.ctxt, advertisingId);
                this.completeTrackInstall();
            }
        }
    }

    public void setAdvertisingIdCommand() {
        --tryCommandCount;
        GetAndroidAdIdCommand adIdCommand = new GetAndroidAdIdCommand(this.ctxt);
        adIdCommand.setOnCommandResult(this);
        adIdCommand.execute();
    }

    @Override
    public void onCommandCompleted(ThreadCommand command) {
        String advertisingId = PrefsManager.readPrefs(this.ctxt, "GLAdvertisingID");
        if (advertisingId == null || advertisingId.length() == 0) {
            if (tryCommandCount > 0) {
                this.setAdvertisingIdCommand();
            } else {
                this.udid = UserDevice.getDeviceUDID(this.ctxt, advertisingId);
                this.completeTrackInstall();
            }
        } else {
            this.udid = UserDevice.getDeviceUDID(this.ctxt, advertisingId);
            this.completeTrackInstall();
        }
    }

    public void completeTrackInstall() {
        if (this.manager != null && this.ctxt != null && this.appId != null && this.udid != null) {
            this.manager.trackInstall(this.ctxt, this.appId, this.udid, this.pkg, this.referrer);
        } else {
            if (this.manager == null) {
                Log.v((String)"NSW", (String)"Failed to trackInstall, InavlidManager.");
            }
            if (this.ctxt == null) {
                Log.v((String)"NSW", (String)"Failed to trackInstall, InvalidContext.");
            }
            if (this.appId == null) {
                Log.v((String)"NSW", (String)"Failed to trackInstall, NotFoundAppID.");
            }
            if (this.udid == null) {
                Log.v((String)"NSW", (String)"Failed to trackInstall InvalidUserInfo.");
            }
        }
    }
}

