/*
 * Decompiled with CFR 0.152.
 */
package kr.co.cashslide;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import kr.co.cashslide.ActionCache;
import kr.co.cashslide.AdvertisingIdHelper;
import kr.co.cashslide.ReferrerReceiver;
import kr.co.cashslide.Request;

public class Cashslide {
    private static final String LOG_TAG = "CashslideSDK";
    private static final String ACTION_REWARD_NOTI = "kr.co.cashslide.REWARD_NOTIFICATION";
    private Context mContext;
    private String mAppId;
    private Request request;
    private ActionCache cache;

    public Cashslide(Context context, String appId) {
        this.mContext = context;
        this.mAppId = appId;
        this.request = new Request(this.mContext, this.mAppId);
        this.cache = new ActionCache(this.mContext);
    }

    public void appFirstLaunched() {
        try {
            if (this.cache.isAppFirstLaunched(this.mAppId)) {
                this.cache.saveAppFirstLaunched(this.mAppId);
                new AppFirstLaunchedTask(this.mContext).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public void missionCompleted() {
        try {
            if (!this.cache.isMissionCompleted(this.mAppId)) {
                this.cache.saveMissionCompleted(this.mAppId);
                new MissionCompletedTask(this.mContext).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public void setRetentionTracking(boolean enable) {
        this.cache.setRetentionTracking(enable);
    }

    public boolean isRetentionTrackingEnabled() {
        return this.cache.isRetentionTrackingEnabled();
    }

    public void recommend() {
        try {
            this.cache.saveRecommendAppId(this.mAppId);
            String nickname = ReferrerReceiver.getRecommendNickname(this.mContext);
            if (TextUtils.isEmpty((CharSequence)nickname)) {
                Log.i((String)LOG_TAG, (String)"referrer is not found.");
                return;
            }
            if (this.cache.isRecommendAvailable(this.mAppId)) {
                new RecommendTask(this.mContext).execute(new Void[0]);
            } else if (this.cache.isRetentionAvailable(this.mAppId)) {
                new RetentionTask(this.mContext).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    class RetentionTask
    extends AsyncTask<Void, Void, Boolean> {
        private Context ctx;

        public RetentionTask(Context ctx) {
            this.ctx = ctx;
        }

        protected Boolean doInBackground(Void ... voids) {
            try {
                AdvertisingIdHelper.updateAdIdSynchronized(Cashslide.this.mContext);
                boolean result = Cashslide.this.request.sendRetention(Cashslide.this.cache.getRetentionCount());
                if (result) {
                    Cashslide.this.cache.saveRecommend(Cashslide.this.mAppId);
                }
                return result;
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
        }
    }

    class RecommendTask
    extends AsyncTask<Void, Void, Boolean> {
        private Context ctx;

        public RecommendTask(Context ctx) {
            this.ctx = ctx;
        }

        protected Boolean doInBackground(Void ... voids) {
            try {
                AdvertisingIdHelper.updateAdIdSynchronized(this.ctx);
                boolean result = Cashslide.this.request.sendRecommend(Cashslide.this.cache.isRetentionTrackingEnabled());
                if (result) {
                    Cashslide.this.cache.saveRecommend(Cashslide.this.mAppId);
                }
                return result;
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
        }
    }

    class MissionCompletedTask
    extends AsyncTask<Void, Void, Boolean> {
        Context ctx;

        private MissionCompletedTask(Context ctx) {
            this.ctx = ctx;
        }

        protected Boolean doInBackground(Void ... arg0) {
            boolean result = false;
            try {
                AdvertisingIdHelper.updateAdIdSynchronized(Cashslide.this.mContext);
                result = Cashslide.this.request.sendMissionCompleted();
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
            }
            return result;
        }

        protected void onPostExecute(Boolean success) {
            try {
                if (success.booleanValue()) {
                    String packageName = null;
                    if (this.ctx != null) {
                        packageName = Cashslide.this.mContext.getPackageName();
                    }
                    int reward = Cashslide.this.request.getReward();
                    Intent intent = new Intent(Cashslide.ACTION_REWARD_NOTI);
                    intent.putExtra("REWARD_COST", reward);
                    intent.putExtra("PACKAGE_NAME", packageName);
                    if (intent != null) {
                        this.ctx.sendBroadcast(intent);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
            }
        }
    }

    class AppFirstLaunchedTask
    extends AsyncTask<Void, Void, Boolean> {
        Context ctx;

        private AppFirstLaunchedTask(Context ctx) {
            this.ctx = ctx;
        }

        protected Boolean doInBackground(Void ... arg0) {
            boolean result = false;
            try {
                AdvertisingIdHelper.updateAdIdSynchronized(Cashslide.this.mContext);
                result = Cashslide.this.request.sendAppFirstLaunched();
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
            }
            return result;
        }

        protected void onPostExecute(Boolean success) {
            try {
                if (success.booleanValue()) {
                    String packageName = null;
                    if (this.ctx != null) {
                        packageName = Cashslide.this.mContext.getPackageName();
                    }
                    int reward = Cashslide.this.request.getReward();
                    Intent intent = new Intent(Cashslide.ACTION_REWARD_NOTI);
                    intent.putExtra("REWARD_COST", reward);
                    intent.putExtra("PACKAGE_NAME", packageName);
                    if (intent != null) {
                        this.ctx.sendBroadcast(intent);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)Cashslide.LOG_TAG, (String)("error:" + e.getMessage()));
            }
        }
    }
}

