/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.OAuthLoginHandler;
import com.nhn.android.naverlogin.connection.CommonConnection;
import com.nhn.android.naverlogin.connection.NetworkState;
import com.nhn.android.naverlogin.connection.OAuthLoginConnection;
import com.nhn.android.naverlogin.connection.ResponseData;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginPreferenceManager;
import com.nhn.android.naverlogin.data.OAuthLoginState;
import com.nhn.android.naverlogin.data.OAuthLoginString;
import com.nhn.android.naverlogin.data.OAuthResponse;
import com.nhn.android.naverlogin.ui.OAuthLoginActivity;
import com.nhn.android.naverlogin.ui.OAuthLoginDialogMng;
import com.nhn.android.naverlogin.util.DeviceAppInfo;

public class OAuthLogin {
    private static final String TAG = "NaverLoginOAuth|OAuthLogin";
    private static OAuthLogin sInstance;
    public static OAuthLoginHandler mOAuthLoginHandler;

    public static OAuthLogin getInstance() {
        if (sInstance == null) {
            sInstance = new OAuthLogin();
        }
        return sInstance;
    }

    private OAuthLogin() {
    }

    public void init(Context context, String clientId, String clientSecret, String clientName) {
        String packageName = DeviceAppInfo.getPackageName(context);
        this.init(context, clientId, clientSecret, clientName, packageName);
    }

    @Deprecated
    public void init(Context context, String clientId, String clientSecret, String clientName, String callbackIntent) {
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        prefMng.setClientId(clientId);
        prefMng.setClientSecret(clientSecret);
        prefMng.setClientName(clientName);
        prefMng.setCallbackUrl(callbackIntent);
        prefMng.setLastErrorCode(OAuthErrorCode.NONE);
        prefMng.setLastErrorDesc("");
    }

    private boolean valid(Context context) {
        if (context == null) {
            Log.i((String)TAG, (String)"context is null");
            return false;
        }
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        if (TextUtils.isEmpty((CharSequence)prefMng.getClientId())) {
            Log.i((String)TAG, (String)"CliendId is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)prefMng.getClientSecret())) {
            Log.i((String)TAG, (String)"CliendSecret is null");
            return false;
        }
        return true;
    }

    public static String getVersion() {
        return "4.1.4.1";
    }

    public OAuthLoginState getState(Context context) {
        if (!this.valid(context)) {
            return OAuthLoginState.NEED_INIT;
        }
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        String at = prefMng.getAccessToken();
        String rt = prefMng.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            if (TextUtils.isEmpty((CharSequence)rt)) {
                return OAuthLoginState.NEED_LOGIN;
            }
            return OAuthLoginState.NEED_REFRESH_TOKEN;
        }
        return OAuthLoginState.OK;
    }

    public void setMarketLinkWorking(boolean set) {
        OAuthLoginDefine.MARKET_LINK_WORKING = set;
    }

    public void startOauthLoginActivity(final Activity activity, final OAuthLoginHandler oauthLoginHandler) {
        if (NetworkState.checkConnectivity((Context)activity, true, new NetworkState.RetryListener(){

            @Override
            public void onResult(boolean retry) {
                if (retry) {
                    OAuthLogin.this.startOauthLoginActivity(activity, oauthLoginHandler);
                }
            }
        })) {
            mOAuthLoginHandler = oauthLoginHandler;
            String rt = this.getRefreshToken((Context)activity);
            if (!TextUtils.isEmpty((CharSequence)rt)) {
                new OAuthLoginTask((Context)activity).execute(new Void[0]);
            } else {
                Intent intent = new Intent((Context)activity, OAuthLoginActivity.class);
                activity.startActivity(intent);
            }
        }
    }

    public String refreshAccessToken(Context context) {
        String refreshToken;
        String clientSecret;
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        String clientId = prefMng.getClientId();
        OAuthResponse res = OAuthLoginConnection.requestRefreshToken(context, clientId, clientSecret = prefMng.getClientSecret(), refreshToken = prefMng.getRefreshToken());
        String at = res.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            return null;
        }
        prefMng.setAccessToken(res.getAccessToken());
        prefMng.setExpiresAt(System.currentTimeMillis() / 1000L + res.getExpiresIn());
        return at;
    }

    public String getAccessToken(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String at = pref.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            return null;
        }
        return at;
    }

    public String getRefreshToken(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String rt = pref.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)rt)) {
            return null;
        }
        return rt;
    }

    public long getExpiresAt(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        long expiresAt = pref.getExpiresAt();
        return expiresAt;
    }

    public String getTokenType(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String tokenType = pref.getTokenType();
        if (TextUtils.isEmpty((CharSequence)tokenType)) {
            return null;
        }
        return tokenType;
    }

    public OAuthErrorCode getLastErrorCode(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        return pref.getLastErrorCode();
    }

    public String getLastErrorDesc(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        return pref.getLastErrorDesc();
    }

    public String requestApi(Context context, String accessToken, String url) {
        String authHeader = "bearer " + accessToken;
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)("at:" + accessToken + ", url:" + url));
            Log.d((String)TAG, (String)("header:" + authHeader));
        }
        ResponseData res = CommonConnection.request(context, url, null, null, authHeader);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)("res.statuscode" + res.mStatusCode));
            Log.d((String)TAG, (String)("res.content" + res.mContent));
        }
        if (res == null) {
            return null;
        }
        return res.mContent;
    }

    public boolean logoutAndDeleteToken(Context context) {
        OAuthResponse res;
        OAuthLoginPreferenceManager prefMng;
        block3: {
            prefMng = new OAuthLoginPreferenceManager(context);
            String clientId = prefMng.getClientId();
            String clientSecret = prefMng.getClientSecret();
            String accessToken = prefMng.getAccessToken();
            this.logout(context);
            res = null;
            try {
                res = OAuthLoginConnection.deleteToken(context, clientId, clientSecret, accessToken);
                if (!"success".equalsIgnoreCase(res.getResultValue())) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                prefMng.setLastErrorCode(OAuthErrorCode.ERROR_NO_CATAGORIZED);
                prefMng.setLastErrorDesc(e.getMessage());
                return false;
            }
        }
        prefMng.setLastErrorCode(res.getErrorCode());
        prefMng.setLastErrorDesc(res.getErrorDesc());
        return false;
    }

    public void logout(Context context) {
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        prefMng.setAccessToken("");
        prefMng.setRefreshToken("");
        prefMng.setLastErrorCode(OAuthErrorCode.NONE);
        prefMng.setLastErrorDesc("");
    }

    private class OAuthLoginTask
    extends AsyncTask<Void, Void, String> {
        private Context _context;
        private OAuthLoginDialogMng mDialogMng = new OAuthLoginDialogMng();

        OAuthLoginTask(Context context) {
            this._context = context;
        }

        protected void onPreExecute() {
            this.mDialogMng.showProgressDlg(this._context, OAuthLoginString.naveroauthlogin_string_getting_token.getString(this._context), null);
        }

        protected String doInBackground(Void ... params) {
            return OAuthLogin.this.refreshAccessToken(this._context);
        }

        protected void onPostExecute(String at) {
            try {
                this.mDialogMng.hideProgressDlg();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)at)) {
                Intent intent = new Intent(this._context, OAuthLoginActivity.class);
                this._context.startActivity(intent);
            } else {
                mOAuthLoginHandler.run(true);
            }
        }
    }

    class OAuthNaverAppInstallMethod {
        static final int TYPE_UPDATE = 144;
        static final int TYPE_INSTALL = 145;

        OAuthNaverAppInstallMethod() {
        }
    }
}

